﻿using System.Collections;
using System.Collections.Generic;
using System;
using NetRuntimeSystem = System;
using System.ComponentModel;
using NetOffice.Attributes;
using NetOffice.CollectionsGeneric;

namespace NetOffice.AccessApi
{
	/// <summary>
	/// DispatchInterface _Form3 
	/// SupportByVersion Access, 12,14,15,16
	/// </summary>
	[SupportByVersion("Access", 12,14,15,16)]
	[EntityType(EntityType.IsDispatchInterface), BaseType, Enumerator(Enumerator.Reference, EnumeratorInvoke.Method)]
	public class _Form3 : _Form2, IEnumerableProvider<object>
    {
		#pragma warning disable

		#region Type Information

		/// <summary>
		/// Instance Type
		/// </summary>
		[EditorBrowsable(EditorBrowsableState.Advanced), Browsable(false), Category("NetOffice"), CoreOverridden]
		public override Type InstanceType
		{
			get
			{
				return LateBindingApiWrapperType;
			}
		}

        private static Type _type;

		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
        public static Type LateBindingApiWrapperType
        {
            get
            {
                if (null == _type)
                    _type = typeof(_Form3);
                return _type;
            }
        }
        
        #endregion
        
		#region Ctor

		/// <param name="factory">current used factory core</param>
		/// <param name="parentObject">object there has created the proxy</param>
		/// <param name="proxyShare">proxy share instead if com proxy</param>
		public _Form3(Core factory, ICOMObject parentObject, COMProxyShare proxyShare) : base(factory, parentObject, proxyShare)
		{
		}

		///<param name="factory">current used factory core</param>
		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
		public _Form3(Core factory, ICOMObject parentObject, object comProxy) : base(factory, parentObject, comProxy)
		{
			
		}

        ///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3(ICOMObject parentObject, object comProxy) : base(parentObject, comProxy)
		{
		}
		
		///<param name="factory">current used factory core</param>
		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        ///<param name="comProxyType">Type of inner wrapped COM proxy"</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3(Core factory, ICOMObject parentObject, object comProxy, NetRuntimeSystem.Type comProxyType) : base(factory, parentObject, comProxy, comProxyType)
		{

		}

		///<param name="parentObject">object there has created the proxy</param>
        ///<param name="comProxy">inner wrapped COM proxy</param>
        ///<param name="comProxyType">Type of inner wrapped COM proxy"</param>
        [EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3(ICOMObject parentObject, object comProxy, NetRuntimeSystem.Type comProxyType) : base(parentObject, comProxy, comProxyType)
		{
		}
		
		///<param name="replacedObject">object to replaced. replacedObject are not usable after this action</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3(ICOMObject replacedObject) : base(replacedObject)
		{
		}
		
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3() : base()
		{
		}
		
		/// <param name="progId">registered progID</param>
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public _Form3(string progId) : base(progId)
		{
		}
		
		#endregion
		
		#region Properties

		/// <summary>
		/// SupportByVersion Access 12
		/// Get
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 12)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public NetOffice.AccessApi.Section get__SectionOld(object index)
		{
			return Factory.ExecuteKnownReferencePropertyGet<NetOffice.AccessApi.Section>(this, "_SectionOld", NetOffice.AccessApi.Section.LateBindingApiWrapperType, index);
		}

		/// <summary>
		/// SupportByVersion Access 12
		/// Alias for get__SectionOld
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 12), Redirect("get__SectionOld")]
		public NetOffice.AccessApi.Section _SectionOld(object index)
		{
			return get__SectionOld(index);
		}
        
		/// <summary>
		/// SupportByVersion Access 10, 11, 12, 14, 15, 16
		/// Get
		/// Unknown COM Proxy
		/// </summary>
		[SupportByVersion("Access", 10,11,12,14,15,16), ProxyResult]
		public object PivotTable
		{
			get
			{
				return Factory.ExecuteReferencePropertyGet(this, "PivotTable");
			}
		}

		/// <summary>
		/// SupportByVersion Access 10, 11, 12, 14, 15, 16
		/// Get
		/// Unknown COM Proxy
		/// </summary>
		[SupportByVersion("Access", 10,11,12,14,15,16), ProxyResult]
		public object ChartSpace
		{
			get
			{
				return Factory.ExecuteReferencePropertyGet(this, "ChartSpace");
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool FilterOnLoad
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "FilterOnLoad");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "FilterOnLoad", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool OrderByOnLoad
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "OrderByOnLoad");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OrderByOnLoad", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public NetOffice.AccessApi.Enums.AcSplitFormOrientation SplitFormOrientation
		{
			get
			{
				return Factory.ExecuteEnumPropertyGet<NetOffice.AccessApi.Enums.AcSplitFormOrientation>(this, "SplitFormOrientation");
			}
			set
			{
				Factory.ExecuteEnumPropertySet(this, "SplitFormOrientation", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public NetOffice.AccessApi.Enums.AcSplitFormDatasheet SplitFormDatasheet
		{
			get
			{
				return Factory.ExecuteEnumPropertyGet<NetOffice.AccessApi.Enums.AcSplitFormDatasheet>(this, "SplitFormDatasheet");
			}
			set
			{
				Factory.ExecuteEnumPropertySet(this, "SplitFormDatasheet", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool SplitFormSplitterBar
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "SplitFormSplitterBar");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "SplitFormSplitterBar", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public NetOffice.AccessApi.Enums.AcSplitFormPrinting SplitFormPrinting
		{
			get
			{
				return Factory.ExecuteEnumPropertyGet<NetOffice.AccessApi.Enums.AcSplitFormPrinting>(this, "SplitFormPrinting");
			}
			set
			{
				Factory.ExecuteEnumPropertySet(this, "SplitFormPrinting", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool SplitFormSplitterBarSave
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "SplitFormSplitterBarSave");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "SplitFormSplitterBarSave", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public string NavigationCaption
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "NavigationCaption");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "NavigationCaption", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnCurrentMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnCurrentMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnCurrentMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeInsertMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeInsertMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeInsertMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterInsertMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterInsertMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterInsertMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeUpdateMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeUpdateMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeUpdateMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterUpdateMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterUpdateMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterUpdateMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnDirtyMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnDirtyMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnDirtyMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnDeleteMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnDeleteMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnDeleteMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeDelConfirmMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeDelConfirmMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeDelConfirmMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterDelConfirmMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterDelConfirmMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterDelConfirmMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnOpenMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnOpenMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnOpenMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnLoadMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnLoadMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnLoadMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnResizeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnResizeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnResizeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnUnloadMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnUnloadMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnUnloadMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnCloseMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnCloseMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnCloseMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnActivateMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnActivateMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnActivateMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnDeactivateMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnDeactivateMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnDeactivateMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnGotFocusMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnGotFocusMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnGotFocusMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnLostFocusMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnLostFocusMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnLostFocusMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnClickMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnClickMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnClickMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnDblClickMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnDblClickMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnDblClickMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnMouseDownMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnMouseDownMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnMouseDownMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnMouseMoveMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnMouseMoveMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnMouseMoveMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnMouseUpMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnMouseUpMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnMouseUpMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnKeyDownMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnKeyDownMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnKeyDownMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnKeyUpMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnKeyUpMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnKeyUpMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnKeyPressMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnKeyPressMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnKeyPressMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnErrorMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnErrorMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnErrorMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnFilterMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnFilterMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnFilterMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnApplyFilterMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnApplyFilterMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnApplyFilterMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnTimerMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnTimerMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnTimerMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnUndoMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnUndoMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnUndoMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnRecordExitMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnRecordExitMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnRecordExitMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeginBatchEditMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeginBatchEditMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeginBatchEditMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string UndoBatchEditMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "UndoBatchEditMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "UndoBatchEditMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeBeginTransactionMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeBeginTransactionMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeBeginTransactionMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterBeginTransactionMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterBeginTransactionMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterBeginTransactionMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeCommitTransactionMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeCommitTransactionMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeCommitTransactionMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterCommitTransactionMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterCommitTransactionMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterCommitTransactionMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string RollbackTransactionMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "RollbackTransactionMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "RollbackTransactionMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnConnectMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnConnectMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnConnectMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string OnDisconnectMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "OnDisconnectMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "OnDisconnectMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string PivotTableChangeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "PivotTableChangeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "PivotTableChangeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string QueryMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "QueryMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "QueryMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeQueryMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeQueryMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeQueryMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string SelectionChangeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "SelectionChangeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "SelectionChangeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string CommandBeforeExecuteMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "CommandBeforeExecuteMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "CommandBeforeExecuteMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string CommandCheckedMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "CommandCheckedMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "CommandCheckedMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string CommandEnabledMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "CommandEnabledMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "CommandEnabledMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string CommandExecuteMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "CommandExecuteMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "CommandExecuteMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string DataSetChangeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "DataSetChangeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "DataSetChangeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeScreenTipMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeScreenTipMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeScreenTipMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterFinalRenderMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterFinalRenderMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterFinalRenderMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterRenderMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterRenderMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterRenderMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string AfterLayoutMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "AfterLayoutMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AfterLayoutMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string BeforeRenderMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "BeforeRenderMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "BeforeRenderMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string MouseWheelMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "MouseWheelMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "MouseWheelMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string ViewChangeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "ViewChangeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "ViewChangeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public string DataChangeMacro
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "DataChangeMacro");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "DataChangeMacro", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool AllowLayoutView
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "AllowLayoutView");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "AllowLayoutView", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public Int32 DatasheetAlternateBackColor
		{
			get
			{
				return Factory.ExecuteInt32PropertyGet(this, "DatasheetAlternateBackColor");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "DatasheetAlternateBackColor", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public byte DisplayOnSharePointSite
		{
			get
			{
				return Factory.ExecuteBytePropertyGet(this, "DisplayOnSharePointSite");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "DisplayOnSharePointSite", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public Int32 SplitFormSize
		{
			get
			{
				return Factory.ExecuteInt32PropertyGet(this, "SplitFormSize");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "SplitFormSize", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 9, 10, 11, 12, 14, 15, 16
		/// Get
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 9,10,11,12,14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public NetOffice.AccessApi._Section get_Section(object index)
		{
			return Factory.ExecuteKnownReferencePropertyGet<NetOffice.AccessApi._Section>(this, "Section", NetOffice.AccessApi._Section.LateBindingApiWrapperType, index);
		}

		/// <summary>
		/// SupportByVersion Access 9, 10, 11, 12, 14, 15, 16
		/// Alias for get_Section
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 9,10,11,12,14,15,16), Redirect("get_Section")]
		public NetOffice.AccessApi._Section Section(object index)
		{
			return get_Section(index);
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public string RibbonName
		{
			get
			{
				return Factory.ExecuteStringPropertyGet(this, "RibbonName");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "RibbonName", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 12, 14, 15, 16
		/// Get/Set
		/// </summary>
		[SupportByVersion("Access", 12,14,15,16)]
		public bool FitToScreen
		{
			get
			{
				return Factory.ExecuteBoolPropertyGet(this, "FitToScreen");
			}
			set
			{
				Factory.ExecuteValuePropertySet(this, "FitToScreen", value);
			}
		}

		/// <summary>
		/// SupportByVersion Access 14, 15, 16
		/// Get
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 14,15,16)]
		[EditorBrowsable(EditorBrowsableState.Never), Browsable(false)]
		public NetOffice.AccessApi.Section get_SectionOld(object index)
		{
			return Factory.ExecuteKnownReferencePropertyGet<NetOffice.AccessApi.Section>(this, "SectionOld", NetOffice.AccessApi.Section.LateBindingApiWrapperType, index);
		}

		/// <summary>
		/// SupportByVersion Access 14, 15, 16
		/// Alias for get_SectionOld
		/// </summary>
		/// <param name="index">object index</param>
		[SupportByVersion("Access", 14,15,16), Redirect("get_SectionOld")]
		public NetOffice.AccessApi.Section SectionOld(object index)
		{
			return get_SectionOld(index);
		}

        #endregion

        #region Methods

        #endregion
      
        #region IEnumerableProvider<object>

        ICOMObject IEnumerableProvider<object>.GetComObjectEnumerator(ICOMObject parent)
        {
            return NetOffice.Utils.GetComObjectEnumeratorAsMethod(parent, this, false);
        }

        IEnumerable IEnumerableProvider<object>.FetchVariantComObjectEnumerator(ICOMObject parent, ICOMObject enumerator)
        {
            return NetOffice.Utils.FetchVariantComObjectEnumerator(parent, enumerator, true);
        }

        #endregion

        #region IEnumerable<object>

        /// <summary>
        /// SupportByVersion Access, 12,14,15,16
        /// </summary>
        [SupportByVersion("Access", 12, 14, 15, 16)]
        public IEnumerator<object> GetEnumerator()
        {
            NetRuntimeSystem.Collections.IEnumerable innerEnumerator = (this as NetRuntimeSystem.Collections.IEnumerable);
            foreach (object item in innerEnumerator)
                yield return item;
        }

        #endregion

        #region IEnumerable

        /// <summary>
        /// SupportByVersion Access, 12,14,15,16
        /// </summary>
        [SupportByVersion("Access", 12,14,15,16)]
		IEnumerator NetRuntimeSystem.Collections.IEnumerable.GetEnumerator()
		{
			return NetOffice.Utils.GetProxyEnumeratorAsMethod(this, true);
		}

		#endregion

		#pragma warning restore
	}
}